//
//-----------------------------------------------------------------------------
// header file for VNA
// (C) 2004 Dave Roberts G8KBB
//
// 13 Aug 2006 - added CmdVnaSetDdsFlagsDdsSetSingleFunction
// 08 Nov 2006 - reallocated IO pins - major changes
//-----------------------------------------------------------------------------


#ifndef _VNA_H_
#define _VNA_H_

//-----------------------------------------------------------------------------
// bit definitions for IO ports
//-----------------------------------------------------------------------------
//
// PortA main VNA I/O
//
#define bmADC1SdoPin    bmBIT7               // Input bit
#define bmLoDdsDataPin  bmBIT6
#define bmRfDdsDataPin  bmBIT5               // rf data shares pin with
#define bmAdcSdiPin     bmBIT5               // adc serial data in
#define bmResetDdsPin   bmBIT4
#define bmWClkDdsPin    bmBIT3
#define bmFQUDDdsPin    bmBIT2
#define bmSwitch1Pin    bmBIT1
#define bmSwitch0Pin    bmBIT0

// PortB second VNA I/O port
//
// warning - see code in manage_out() as it assumes
// bmAtten bits are in the positions shown
//
#define bmADC2SdoPin     bmBIT7              // Input bit
#define bmVNAPower       bmBIT6              // Input bit
#define bmADC1CsPin  	 bmBIT5				 // copy of ADC1cs pin
#define bmAtten2         bmBIT4
#define bmAtten1         bmBIT3
#define bmAtten0         bmBIT2
#define bmADC2CsPin      bmBIT1
#define bmADCnSClkPin    bmBIT0


//-----------------------------------------------------------------------------
// bit & byte definitions for messages
//-----------------------------------------------------------------------------
//
//-----------------------------------------------------------------------------
// set DDS & start ADC conversion
#define CmdVnaSetDds           0x55           // command in first byte of message
#define CmdVnaSetDdsFlagsOfs   1              // offset in message to flags byte
#define CmdVnaSetDdsAdcDelOfs  2              // offset to ADC start delay (msec)
#define CmdVnaSetDdsAdcReads   3              // offset to ADC read count
#define CmdVnaSetAdcMode       4              // offset to ADC control byte
#define CmdVnaSetDdsLoOfs      5              // offset to LO DDS setting (5 bytes)
#define CmdVnaSetDdsRfOfs      10              // offset to LO DDS setting (5 bytes)
#define CmdVnaSetDdsSize       15             // total size of message in bytes

#define CmdVnaSetDdsLoOfs2     15              // offset to LO DDS 2 setting (5 bytes)
#define CmdVnaSetDdsRfOfs2      20              // offset to LO DDS 2 setting (5 bytes)
#define CmdVnaSetDdsSizeLong   (CmdVnaSetDdsSize+10) // extended message with 2 DDS settings


// bit definitions for Flags
#define CmdVnaSetDdsFlagsReset           bmBIT7         //if set, reset DDS before loading
#define CmdVnaSetDdsFlagsDdsSet          bmBIT6         //if set, configure the DDSs
#define CmdVnaSetDdsFlagsDelayIsUsec     bmBIT5         //if set, delay AdcDel is in usec not millisec
#define CmdVnaSetDdsFlagsPauseDataIn     bmBIT4         //if set, stop returning IN data until ADC conversions done
#define CmdVnaSetDdsFlagsPauseDataOut    bmBIT3         //if set, do not process incoming messages till ADC done
#define CmdVnaSetDdsFlagsDdsSetSingleFunction bmBIT2	//if set DDS if B6 set or pulse FQUD if clear but not both
#define CmdVnaSetDdsFlagsDoubleConversion bmBIT1        //if set, there should be 2 sets of DDS data - do ADC conv twice
#define CmdVnaSetDdsFlagsPreloadDDS 	 bmBIT0         // if set preload DDS during ADC conversion
// other bits unused and ignored

// bit definitions for Adc Mode
#define CmdVnaSetDdsAdcModeDet2          bmBIT7         //if set use second detector
#define CmdVnaSetDdsAdcModeSimultaneous  bmBIT6			// if set, use both ADCs at once
// bits 5 unused
// bits 4..0 are LTC2440 OSR4..0

// bit definitions for ADCcount
// if bit 7 is set, force switch lines from bits 6,5 when DDS is set or when starting conversion
#define CmdVnaSetDdsAutoSwitch			bmBIT7
#define CmdVnaSetDdsAutoSwitch1			bmBIT6
#define CmdVnaSetDdsAutoSwitch0			bmBIT5
// bottom 5 bits are the ADC count itself
#define ADC_COUNT_MASK 		(0x1f)

//-----------------------------------------------------------------------------
// configure command
#define CmdVnaConfigure 0xA5
#define CmdVnaConfigureFlagsOfs 1
#define CmdVnaConfigureModeValue 2
#define CmdVnaConfigureMinDelayValue 3

#define CmdVnaConfigureSizeMin 4

// flag values
#define CmdVnaConfigureModeOverrideOn bmBIT7
#define CmdVnaConfigureModeDelayMin bmBIT6

//-----------------------------------------------------------------------------
// read eeprom command
#define CmdReadEEPROM 0xAC
#define CmdReadEEPROMFlagsOfs 1
#define CmdReadEEPROMAddress 2
#define CmdReadEEPROMLength 4

#define CmdReadEEPROMSizeMin 5

// no flags currently defined

//-----------------------------------------------------------------------------
// write eeprom command
#define CmdWriteEEPROM 0xA3
#define CmdWriteEEPROMFlagsOfs 1
#define CmdWriteEEPROMAddress 2
#define CmdWriteEEPROMLength 4
#define CmdWriteEEPROMData 5

#define CmdWriteEEPROMSizeMin 6

// no flaga currently defined

//-----------------------------------------------------------------------------
// Raw Write to port ( returns read value )
#define CmdVnaRawData          0x5A           // command to set & read data port
#define CmdVnaRawDataFlagsOfs  1              // offset in message to flag byte
#define CmdVnaRawDataPortOfsA  2              // offset in message to port write data A
#define CmdVnaRawDataPortOfsB  3              // offset in message to port write data B
#define CmdVnaRawDataSetAtten  4              // offset to value for attenuator (0..7)
#define CmdVnaRawDataPortOfsD  5              // offset to value port D
#define CmdVnaRawDataSetSwitch 6              // offset to switch value
#define CmdVnaRawDataSizeMin   5              // total size of message in bytes (port D optional)
// bit definitions for Flags
#define CmdVnaRawDataFlagsWriteA bmBIT7       //if set, write specifiied value to port A
#define CmdVnaRawDataFlagsWriteB bmBIT6       //if set, write specifiied value to port B
#define CmdVnaRawDataFlagsSetAtt bmBIT5       //if set, set attenuator value
#define CmdVnaRawDataFlagsWriteD bmBIT4       //if set, write specifiied value to port B
#define CmdVnaRawDataFlagsSetSw  bmBIT3       //if set, write specifiied value to port B

//-----------------------------------------------------------------------------
// bit & byte definitions for Sweep
//
#define CmdVnaSwpDds           0xAA           // command in first byte of message
#define CmdVnaSweepFlagsOfs    1              // offset in message to flags byte
#define CmdVnaSweepStepDelOfs  2              // offset per step delay (msec)
#define CmdVnaSweepInitDelOfs  3              // offset to inter sweep delay
#define CmdVnaSweepSteps       4              // offset to 4 byte step count
#define CmdVnaSweepLoOfs       8              // offset to LO DDS start setting (5 bytes)
#define CmdVnaSweepRfOfs      13              // offset to LO DDS start setting (5 bytes)
#define CmdVnaSweepLoStepOfs  18              // offset to LO DDS step setting (5 bytes)
#define CmdVnaSweepRfStepOfs  23              // offset to LO DDS step setting (5 bytes)
#define CmdVnaSweepSize       28             // total size of message in bytes

// flag definitions
#define CmdVnaSweepFlagsPulseSW1            bmBIT7  // set SW1 high when sweeping
#define CmdVnaSweepFlagsStepDelayIsUsec     bmBIT6  // delay between steps is in usec
#define CmdVnaSweepFlagsInitDelayIsUsec     bmBIT5  // delay between sweeps is in usec
#define CmdVnaSweepFlagsPowerDownBetween    bmBIT4  // power down DDSes between sweeps

//-----------------------------------------------------------------------------
// bit definitions for ReturnStatus
//-----------------------------------------------------------------------------

#define AdcReadTimeout         bmBIT7              // attempt to read ADC timed out
#define VnaNoPower             bmBIT6              // The VNA appears not to be powered up
#define AdcDataReady           bmBIT5              // ADC data is available
#define AdcStartFlag           bmBIT4              // set when ADC read is pending
#define AdcNotResponding       bmBIT3              // SDO was not high immediately after start

#define EEPROMDataPresent      bmBIT1			   // eeprom read data present

//-----------------------------------------------------------------------------
// Miscellaneous definitions
//-----------------------------------------------------------------------------

#define ADCMAXREADS		30		// max number of ADC reads in one request

// min delay = 24 + (8 * DEFMINADCDELAY)
#define DEFMINADCDELAY	4		// gives approx 50 usec min ADC start delay
// #define DEFMINADCDELAY	10		// gives approx 100 usec min ADC start delay

//-----------------------------------------------------------------------------
// function prototypes
//-----------------------------------------------------------------------------
void AdcTimeout();

#endif // _VNA_H_


